function getDomainPath() {
  var getPath = location.pathname.replace("/showroom/", "").replace("/index.html", "").replace("/index-fortuner.html", "").replace("/", "").replace("-", "");
  var path = getPath.trim();
  if (path === "fortunerindexlegender.html") {
    path = "legender";
  }
  return path;
}
function getDate() {
  var currentDate = new Date();
  currentDate.setHours(currentDate.getHours() + 5);
  currentDate.setMinutes(currentDate.getMinutes() + 30);
  var currentDateTime = currentDate.toISOString();
  return currentDateTime;
}
// function successTestData() {
//   var name = $("#txtName").val();
//   var mobile = "+91" + $("#txtMobile").val();
//   var email = $("#txtEmail").val();
//   var city = $("#cboCity option:selected").text();
//   var dealer = $("#cboDealer option:selected").text();
//   var eventName = "test_drive";
//   var time = getDate();
//   var productName = getDomainPath();
//   Insider.track("events", [
//     {
//       event_name: eventName,
//       timestamp: '"' + time + '"',
//       event_params: {
//         dealer: dealer,
//         city_type: city,
//         name_type: name,
//         mobile_no_type: mobile,
//         product_name: productName,
//         email_type: email,
//       },
//     },
//   ]);
// }
function onEMISuccess() {
  var fuelType = $("#cboEMIFuelType").val();
  var variant = $("#cboEMIVariant option:selected").text();
  var state = $("#cboEMIState option:selected").text();
  var city = $("#cboEMICity option:selected").text();
  var eventName = "emi_calculator";
  var time = getDate();
  var productName = getDomainPath();
  Insider.track("events", [
    {
      event_name: eventName,
      timestamp: '"' + time + '"',
      event_params: {
        custom: {
          product_name: productName,
          fuel_type: fuelType,
          variant_type: variant,
          state_type: state,
          city_type: city,
        },
      },
    },
  ]);
}
$(document).ready(function () {
  // virtual showroom for all cars

  $("#virtualShowroom").click(function () {
    var eventName = "vsr_banner_clicked";
    var time = getDate();
    var source = document.referrer;
    var productName = getDomainPath();
    Insider.track("events", [
      {
        event_name: eventName,
        timestamp: '"' + time + '"',
        event_params: {
          custom: {
            source: source,
            product_name: productName,
          },
        },
      },
    ]);
  });

  // Brochure for all cars

  $(".view-brochure").click(function () {
    var eventName = "brochure_view_download";
    var time = getDate();
    var brochure_type = $(this).find("span").text().trim();
    var productName = getDomainPath();
    Insider.track("events", [
      {
        event_name: eventName,
        timestamp: '"' + time + '"',
        event_params: {
          custom: {
            brochure_type: brochure_type,
            product_name: productName,
          },
        },
      },
    ]);
  });

  // E-Book for all cars

  $("#divEBook").click(function () {
    var eventName = "ebook_clicked";
    var time = getDate();
    var source = document.referrer;
    var productName = getDomainPath();
    Insider.track("events", [
      {
        event_name: eventName,
        timestamp: '"' + time + '"',
        event_params: {
          custom: {
            source: source,
            product_name: productName,
          },
        },
      },
    ]);
  });

  // sticky navigation for all cars

  $(".row-item").click(function () {
    var sticky = $(this).find("p").text();
    var eventName = "sticky_navigation";
    var source = document.referrer;
    var productName = getDomainPath();
    var time = getDate();
    Insider.track("events", [
      {
        event_name: eventName,
        timestamp: '"' + time + '"',
        event_params: {
          custom: {
            source: source,
            destination_type: productName + " " + sticky,
          },
        },
      },
    ]);
  });

  // color section for rumion, hyryder, innova, fortuner, vellfire

  $(".car_color").click(function () {
    if ($(this).find("h4") || $(this).find("a").find("h6") || $(this).find("span")) {
      var value = $(this).text().trim();
      if (value) {
        var eventName = "color_customisation";
        var time = getDate();
        var productName = getDomainPath();
        Insider.track("events", [
          {
            event_name: eventName,
            timestamp: '"' + time + '"',
            event_params: {
              custom: {
                color: value,
                product_name: productName,
              },
            },
          },
        ]);
      } else {
        var eventName = "color_customisation";
        var time = getDate();
        var productName = getDomainPath();
        var color = $(this).attr("data-cvname");
        Insider.track("events", [
          {
            event_name: eventName,
            timestamp: '"' + time + '"',
            event_params: {
              custom: {
                color: value,
                product_name: productName,
              },
            },
          },
        ]);
      }
    }
  });

  // color section for innova crysta

  $(".nav-tabs.color_tab li a").on("click", function (e) {
    e.preventDefault();
    var targetTabId = $(this).attr("href");
    var $targetTabPane = $(targetTabId);
    $targetTabPane.addClass("active").siblings().removeClass("active");
    var eventName = "color_customisation";
    var time = getDate();
    var productName = getDomainPath();
    var color = $targetTabPane.parent()[0].innerText;
    Insider.track("events", [
      {
        event_name: eventName,
        timestamp: '"' + time + '"',
        event_params: {
          custom: {
            color: value,
            product_name: productName,
          },
        },
      },
    ]);
  });
});

// color section for glanza, taisor

function setColorName(color) {
  var eventName = "color_customisation";
  var time = '"' + getDate() + '"';
  var productName = getDomainPath();
  Insider.track("events", [
    {
      event_name: eventName,
      timestamp: time,
      event_params: {
        custom: {
          color: color,
          product_name: productName,
        },
      },
    },
  ]);
}
